/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.drink;

import cloud.lemonslice.teastory.block.drink.TeapotBlock;
import cloud.lemonslice.teastory.blockentity.TeapotBlockEntity;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.block.NormalHorizontalBlock;
import xueluoanping.teastory.fluid.HotWaterFlowingFluidBlock;
import xueluoanping.teastory.registry.BlockEntityRegister;

public class IronKettleBlock
extends TeapotBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = VoxelShapeHelper.createVoxelShape(2.0, 0.0, 2.0, 12.0, 11.0, 12.0);

    public IronKettleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof TeapotBlockEntity && ((TeapotBlockEntity)tileentity).getFluid().getFluidType().getTemperature() >= 333) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + rand.m_188500_() * 6.0 / 16.0;
            double d2 = (double)pos.m_123343_() + 0.5;
            double d4 = rand.m_188500_() * 0.6 - 0.3;
            worldIn.m_6493_((ParticleOptions)ParticleTypes.f_123796_, false, d0 + d4, d1 + 0.5, d2 + d4, 0.0, 0.1, 0.0);
        }
    }

    @Override
    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.m_142535_(fallDistance, 1.0f, worldIn.m_269111_().m_268989_());
    }

    public void m_7892_(BlockState p_60495_, Level worldIn, BlockPos pos, Entity entityIn) {
        BlockEntity te;
        if (entityIn instanceof LivingEntity && (te = worldIn.m_7702_(pos)) instanceof TeapotBlockEntity && ((TeapotBlockEntity)te).getFluid().getFluidType().getTemperature() >= 333) {
            entityIn.m_6469_(HotWaterFlowingFluidBlock.getBoiling(worldIn), 1.0f);
        }
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BlockEntityRegister.IRON_KETTLE_TYPE.get()).m_155264_(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.f_46443_ ? NormalHorizontalBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)BlockEntityRegister.IRON_KETTLE_TYPE.get(), TeapotBlockEntity::tick) : null;
    }
}

